<div class="main-content">




    <!-- ------------------------------------------------------------------- -->
    <section class="section">
        <div class="section-header">
            <h1><?= labels('provider', "Add Provider") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/partners') ?>"><i class="fas fa-handshake text-warning"></i> <?= labels('provider', 'Provider') ?></a></div>
                <div class="breadcrumb-item"><?= labels('add_provider', " Add Provider") ?></a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <h2 class='section-title'><?= labels('provider_details', "Provider Details") ?></h2>
            <div class="form-wrapper">
                <?= form_open('/admin/partner/insert_partner', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_partner', 'enctype' => "multipart/form-data"]); ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="company"><?= labels('company_name', 'Company Name') ?></label>
                            <input id="company_name" class="form-control" type="text" name="company_name" placeholder="<?= labels('enter', 'Enter ') ?> <?= labels('company_name', 'the company name ') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="type"><?= labels('type', 'Type') ?></label>
                            <select class="form-control" name="type" id="type" required>
                                <option disabled selected><?= labels('select_type', 'Select Type') ?></option>
                                <option value="0"><?= labels('individual', 'Individual') ?></option>
                                <option value="1"><?= labels('organization', 'Organization') ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <div class="form-group">
                            <label for="about"><?= labels('about_provider', 'About Provider') ?></label>
                            <textarea id="about" class="form-control" type="text" name="about" rowspan="10" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('about_provider', 'About Provider') ?> <?= labels('here', ' Here ') ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="visiting_charges"><?= labels('visiting_charges', 'Visiting Charges') ?></label>
                            <input id="visiting_charges" class="form-control" type="number" name="visiting_charges" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('visiting_charges', 'Visiting Charges') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="advance_booking_days"><?= labels('advance_booking_days', 'Advance Booking Days') ?></label>
                            <input id="advance_booking_days" class="form-control" type="number" name="advance_booking_days" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('advance_booking_days', 'Advance Booking Days') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="number_of_members"><?= labels('number_Of_members', 'Number of Members') ?></label>
                            <input id="number_of_members" class="form-control" type="text" name="number_of_members" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('number_Of_members', 'Number of Members') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= labels('status', 'Status') ?><span class="text-danger text-sm">*</span></label>
                            <br>
                            <div id="is_approved" class="btn-group col-sm-8" style="margin-left: -11px;">
                                <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="is_approved" value="1"><?= labels('approved', 'Approved') ?>
                                </label>
                                <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="is_approved" value="0" checked> <?= labels('not_approved', 'Not approved') ?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="name"><?= labels('image', 'Image') ?> </label><br>
                            <div class="file-upload">
                                <div class="file-select">
                                    <div class="file-select-button" id="fileName"><?= labels('choose_file', 'Choose File') ?></div>
                                    <div class="file-select-name" id="noFile"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                    <input type="file" name="image" id="image" accept="image/*">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="banner_image"><?= labels('banner_image', 'Banner Image') ?></label><br>
                            <div class="file-upload">
                                <div class="file-select">
                                    <div class="file-select-button" id="fileName2"><?= labels('choose_file', 'Choose File') ?></div>
                                    <div class="file-select-name" id="noFile2"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                    <input type="file" name="banner_image" id="banner_image" accept="image/*">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <h2 class='section-title'><?= labels('provider_location_information', "Location Information") ?></h2>
                <div class="row">
                    <div class="col-md-6">
                        <div id="map_wrapper_div_partner">
                            <div id="partner_map">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="partner_location"><?= labels('current_location', 'Current Location') ?></label>
                                <input id="partner_location" class="form-control" type="text" name="partner_location">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <div class="cities" id="cities_select">
                                    <label for="city"><?= labels('city', 'City') ?></label>
                                    <input type="text" name="city" class="form-control" placeholder="<?= labels('enter_your_providers_city_name', 'Enter your provider\'s city name') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="partner_latitude"><?= labels('latitude', 'Latitude') ?></label>
                                <input id="partner_latitude" class="form-control" type="text" name="partner_latitude" placeholder="<?= labels('latitude', 'Latitude') ?>" required>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="partner_longitude"><?= labels('longitude', 'Longitude') ?></label>
                                <input id="partner_longitude" class="form-control" type="text" name="partner_longitude" placeholder="<?= labels('longitude', 'Longitude') ?>" required>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="address"><?= labels('address', 'Address') ?></label>
                                <textarea id="address" class="form-control" name="address" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('address', 'Address') ?> <?= labels('here', ' Here ') ?>" required></textarea>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <h2 class='section-title'><?= labels('working_days', 'Working Days') ?></h2>

                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="0"><?= labels('monday', 'Monday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" required id="0" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[0]['opening_time']) ? $partner_timings[0]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="0" required class="form-control end_time" name="end_time[]" value="
                                    <?php
                                    (isset($partner_timings[0]['closing_time']) ? $partner_timings[0]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (isset($partner_timings) && !empty($partner_timings) && $partner_timings[0]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="monday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="monday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="1"> <?= labels('tuesday', 'Tuesday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="1" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[1]['opening_time']) ? $partner_timings[1]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="01" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[1]['closing_time']) ? $partner_timings[1]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="tuesday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="tuesday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="2"> <?= labels('wednesday', 'Wednesday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="2" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[2]['opening_time']) ? $partner_timings[2]['opening_time'] : '0') ?> ">
                                </div>
                                <div class="col-md-1  text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="02" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[2]['closing_time']) ? $partner_timings[2]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[2]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="wednesday" id="flexCheckDefault">
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="wednesday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="3"> <?= labels('thursday', 'Thursday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="3" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[3]['opening_time']) ? $partner_timings[3]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[3]['closing_time']) ? $partner_timings[3]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="thursday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="thursday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="4"> <?= labels('friday', 'Friday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="4" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[4]['opening_time']) ? $partner_timings[4]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[4]['closing_time']) ? $partner_timings[4]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="friday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="friday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="5"> <?= labels('saturday', 'Saturday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="5" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[5]['opening_time']) ? $partner_timings[5]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[5]['closing_time']) ? $partner_timings[5]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="saturday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="saturday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="6"> <?= labels('sunday', 'Sunday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="6" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[6]['opening_time']) ? $partner_timings[6]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[6]['closing_time']) ? $partner_timings[6]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="sunday" id="flexCheckDefault" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="sunday" id="flexCheckDefault">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-12 col-md-6 col-lg-12">
                <div class="card">
                    <div class="card-header bg-navy border-0 h5">
                        <h2 class='section-title'> <?= labels('personal_details', 'Personal Details') ?></h2>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-4">
                                <div class="form-group">
                                    <label for="name"><?= labels('name', 'Name') ?></label>
                                    <input id="username" class="form-control" type="text" name="username" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('name', 'Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="form-group">
                                    <label for="email"><?= labels('email', 'Email') ?></label>
                                    <input id="email" class="form-control" type="text" name="email" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('email', 'Email') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="phone"><?= labels('phone_number', 'Phone Number') ?></label>
                                    <input id="phone" class="form-control" type="number" name="phone" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('phone_number', 'Phone Number') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="password"><?= labels('password', 'Password') ?></label>
                                    <input id="password" class="form-control" type="password" name="password" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('password', 'Password') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="admin_commission"><?= labels('commision', 'Commision') ?>(%)<small>( <?= labels('commision', 'Commision') ?>(%)<?= labels('commision_note', 'to be given to the Super Admin on Service') ?>)</small></label>
                                    <input id="admin_commission" class="form-control" type="number" name="admin_commission" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('commision', 'Commision') ?> <?= labels('here', ' Here ') ?>" min="0" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="passport"><?= labels('passport', 'Passport') ?></label><br>
                                    <div class="file-upload">
                                        <div class="file-select">
                                            <div class="file-select-button" id="fileName3"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile3"><?= labels('no_file_chosen', 'No file chosen...') ?>.</div>
                                            <input type="file" name="passport" id="passport" accept="image/*" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="national_id"><?= labels('national_identity', 'National Identity') ?></label><br>
                                    <div class="file-upload">
                                        <div class="file-select">
                                            <div class="file-select-button" id="fileName4"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile4"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                            <input type="file" name="national_id" id="national_id" accept="image/*" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="national_id"><?= labels('address_id', 'Address Identity') ?></label><br>
                                    <div class="file-upload">
                                        <div class="file-select">
                                            <div class="file-select-button" id="fileName5"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile5"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                            <input type="file" name="address_id" id="address_id" accept="image/*" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 col-lg-12">
                <div class="card">
                    <div class="card-header bg-navy border-0 h5">
                        <h2 class='section-title'><?= labels('bank_details', 'Bank Details') ?></h2>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tax_name"><?= labels('tax_name', 'Tax Name') ?></label>
                                    <input id="tax_name" class="form-control" type="text" name="tax_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('tax_name', 'Tax Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tax_number"><?= labels('tax_number', 'Tax Number') ?></label>
                                    <input id="tax_number" class="form-control" type="text" name="tax_number" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('tax_number', 'Tax Number') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_number"><?= labels('account_number', 'Account Number') ?></label>
                                    <input id="account_number" class="form-control" type="text" name="account_number" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('account_number', 'Account Number') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_name"><?= labels('account_name', 'Account Name') ?></label>
                                    <input id="account_name" class="form-control" type="text" name="account_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('account_name', 'Account Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="bank_code"><?= labels('bank_code', 'Bank Code') ?></label>
                                    <input id="bank_code" class="form-control" type="text" name="bank_code" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('bank_code', 'Bank Code') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="bank_name"><?= labels('bank_name', 'Bank Name') ?></label>
                                    <input id="bank_name" class="form-control" type="text" name="bank_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('bank_name', 'Bank Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="swift_code"><?= labels('swift_code', 'Swift Code') ?></label>
                                    <input id="swift_code" class="form-control" type="text" name="swift_code" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('swift_code', 'Swift Code') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col ">
                <div class="" style="margin-bottom: 25px;">
                    <button type="reset" class="btn btn-lg btn-warning"><?= labels('Reset', 'Reset') ?></button>
                    <button type="submit" class="btn btn-lg btn-success"><?= labels('add_provider', " Add Provider") ?></button>
                    <?= form_close(); ?>
                </div>
            </div>
        </div>
    </section>


    <!-- ----------------------------------------------------------------------------------------------------- -->




</div>
<style>
</style>
<script>
    $('#image').bind('change', function() {
        var filename = $("#image").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#banner_image').bind('change', function() {
        var filename = $("#banner_image").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile2").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile2").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#passport').bind('change', function() {
        var filename = $("#passport").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile3").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile3").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#national_id').bind('change', function() {
        var filename = $("#national_id").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile4").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile4").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#address_id').bind('change', function() {
        var filename = $("#address_id").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile5").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile5").text(filename.replace("C:\\fakepath\\", ""));
        }
    });



    $('#image').bind('change', function() {
        var filename = $("#image").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile").text(filename.replace("C:\\fakepath\\", ""));
        }
    });

    $('#type').change(function() {
        var doc = document.getElementById("type");

        if (doc.options[doc.selectedIndex].value == 0) {
            // console.log('0 selectc');
            $("#number_of_members").val('1');

            $("#number_of_members").attr("readOnly", "readOnly");
        } else if (doc.options[doc.selectedIndex].value == 1) {

            $("#number_of_members").val('');
            $("#number_of_members").removeAttr("readOnly");

        }
        // alert("You selected " + doc.options[doc.selectedIndex].value);
    });


    $('.start_time').change(function() {
        var doc = $(this).val();
        console.log(doc);
        $(this).parent().siblings(".endTime").children().attr('min', doc);

    });
</script>